package gov.va.med.mhv.rxrefill.enums;


public enum MhvStatusEnumeration {
	NOTFILLED("notFilled", 2),
	FILLED("filled", 1),
	OTHERERROR("otherError", 0),
	RESULTSBACKORNOTPICKEDUP("resultsBackOrNotPickedUp", -1),
	PENDING("pending", -2),
	UNABLETORESOLVEPATIENT("unableToResolvePatient", -3),
	RESOLVEPRESCRIPTION("resolvePrescription", -4),
	DFNNOTMATCHRX("dfnNotMatchRX", -5),
	RXNOTIN5243("rxNotIn5243", -6);

	private String description;
	private int value;

	MhvStatusEnumeration(String description, int value) {
		this.description = description;
		this.value = value;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public int getValue() {
		return value;
	}

	public void setValue(int value) {
		this.value = value;
	}
	
	public static String getStatus(int value) {
		for (MhvStatusEnumeration e : MhvStatusEnumeration.values()) {
			if (e.getValue() == value) {
				return e.getDescription();
			}
		}
		return null;
	}
	
	public static Integer getValue(String status) {
		for (MhvStatusEnumeration e : MhvStatusEnumeration.values()) {
			if (e.getDescription().equalsIgnoreCase(status)) {
				return e.getValue();
			}
		}
		return null;
	}
}
